@extends('admin.master')
@section('title')
@php $world=DB::table('companies')->first(); @endphp
Withdraw  || {{$world->name}}
@endsection
@section('content')
<div class="page-content fade-in-up">
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
<div class="modal-dialog  modal-sm modal-dialog-centered" role="document">
<div class="modal-content">
<div class="modal-header">
    <h5 class="modal-title" id="exampleModalLongTitle">Member Withdraw</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<form enctype="multipart/form-data" action="{{url('/withdraw_store')}}" method="post">
  @csrf
    <div class="modal-body">
        <div class="row">
 
         <div class="col-sm-12 form-group">
            <label>Member</label>
            <select name="member" required class="form-control select2bs4" style="width: 100%;">
             <option value="">Select Member</option>
           @foreach($member as $member)
             <option value="{{$member->id}}">{{$member->memberno}}-{{$member->name}}</option>
             @endforeach
            </select>
        </div>
          <div class="col-sm-12 form-group">
            <label>Date</label>
            <input class="form-control"  required value="<?php echo date('Y-m-d'); ?>" type="date"  name="date">
        </div>
         <div class="col-sm-12 form-group">
            <label>Token</label>
            <input class="form-control" required  type="number" min="1"  name="free">
        </div>
        <div class="col-sm-12 form-group">
            <label>Amount</label>
            <input class="form-control"  required type="number" min="1"  name="amount">
        </div>
        </div>
       </div>
    <div class="modal-footer">
        <button type="reset" class="btn btn-primary" >Clear</button>
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Submit</button>
    </div>
</form>
</div>
</div>
</div>

{{-- Edit slider Modal --}}

<div class="modal fade" id="exampleModalCenter_edit" tabindex="-1" role="dialog"
aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
<div class="modal-dialog  modal-sm modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle"> Update</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
      <form enctype="multipart/form-data" action="{{url('/withdraw_update')}}" method="post" >
        @csrf
    <div class="modal-body">
        <div class="row">

         <div class="col-sm-12 form-group">
            <label>Member</label>
            <select name="member" required class="form-control select2bs4 member" style="width: 100%;">
             <option value="">Select Member</option>
           @foreach($members as $members)
             <option value="{{$members->id}}">{{$members->memberno}}-{{$members->name}}</option>
             @endforeach
            </select>
        </div>
          <div class="col-sm-12 form-group">
            <label>Date</label>
            <input class="form-control date"  required type="date"  name="date">
            <input class="cId" type="hidden" name="id" id="id">

        </div>
         <div class="col-sm-12 form-group">
            <label>Token</label>
            <input class="form-control free"  type="number" min="1"  name="free">
        </div>
        <div class="col-sm-12 form-group">
            <label>Amount</label>
            <input class="form-control amount"  type="number" min="1"  name="amount">
        </div>
        </div>
       </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Update</button>
    </div>
</form>
</div>
</div>
</div>
</div>
<div class="card shadow">
   <div class="card-header ">
    <div class="row">
        <div class="col-md-3">
          <h3 class="m-0 font-weight-bold ">Withdraw List </h3>
        </div>   
  
    <div class="col-md-6">
      <form action="{{url('/withdraw')}}" method="get"> 
              @csrf 
           <div class="row">    
                      <div class="col-md-8">
                        <select name="member" required class="form-control select2bs4" style="width: 100%;">
                          <option value="">Select  Member</option>
                          @foreach($memberss as $memberss)
                          <option value="{{$memberss->id}}">{{$memberss->memberno}}={{$memberss->name}}</option>
                          @endforeach
                         </select>
                       </div>
                        <div class="col-md-4 ">
                         <input type="submit" class="btn btn-secondary" value="Search"/>
                              </div>
                        </div>
                          </form>
                   
                  </div>
                  <div class="col-md-3">
                <button type="button" class="btn btn-success fa-pull-right" data-toggle="modal" data-target="#exampleModalCenter" >
             Withdraw   
            </button>
        </div>
            
          </div> 
        </div> 
    <div class="card-body">
      <div class="table-responsive">
       <table  class="table table-bordered table-hover table-sm">
          <thead>
             <tr class="bg-info">
              <th>SL</th>
              @if(Session::get("role")==1 or Session::get("role")==3)
              <th>User</th>
              @endif
              <th>M.ID</th>        
              <th>Name</th>
              <th>Mobile</th>
              <th>Date</th>
              <th>Token</th>
              <th>Amount</th>
              @if( Session::get("role")==3)
              <th>Action</th>
              @endif
            </tr>
          </thead>
          <tbody>
          
        
          @foreach($withdraw as $user)
          @php $result=DB::table('users')->find($user->userid) @endphp
         <tr>
          <td>{{$user->id}}</td>
          @if(Session::get("role")==1 or Session::get("role")==3)
            <td>{{@$result->name}}</td>
          @endif
          <td>{{$user->memberno}}</td>
          <td>{{$user->name}}</td>
          <td>{{$user->mobile}}</td>
          {{-- <td>{{ date('d-M-Y', strtotime($user->date)) }}</td> --}}

          @if((date(' d-M-Y', strtotime($user->date)))==(date(' d-M-Y', strtotime($user->created_at))))
          <td>{{ date(' d-M-Y', strtotime($user->date)) }} ( {{ date('h:i a', strtotime($user->created_at)) }} )</td>
            @else
            <td style="color:red;">{{ date(' d-M-Y', strtotime($user->date)) }} ( {{ date('h:i a', strtotime($user->created_at)) }} ) <br>
              {{ date(' d-M-Y', strtotime($user->created_at)) }}</td>
            @endif


          <td> {{$user->free}}</td>
          <td> {{$user->amount}}</td>
         
            @if(Session::get("role")==3)
            <td>
            <a href="" onclick= 'edit({{$user->id}});' data-toggle="modal" id="edit" 
            data-target="#exampleModalCenter_edit" class="btn btn-sm btn-info" ><i class="fa fa-edit "></i></a>            
          <a href="{{url('/withdraw_delete/'.$user->id)}}" onclick='alert("Confirm Delete ??")' ><button class="btn  btn-sm btn-danger"><i class="fa fa-trash "></i></button></a>
        </td>
          @endif
            
           
           </tr>
         @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>  
<script>
  function edit(id) {
          var x =id;
          
          $.ajax({
              type:'GET',
              url:"{{url('/withdraw_edit')}}/"+x,
              success:function(response){
                  console.log(response);
                  $('.member').val(response.memberid);
                  $('.date').val(response.date);
                  $('.free').val(response.free);
                  $('.amount').val(response.amount);
                  $('.cId').val(response.id);
           
              },
              error:function(xhr,status,error){
                  console.log(error);
                  
              }
  
          });
      }
  
          
  </script>

@endsection