@extends('admin.master')
@section('title')
@php $world=DB::table('companies')->first(); @endphp
User || {{$world->name}}
@endsection
@section('content')
<div class="page-content fade-in-up">
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
<div class="modal-dialog  modal-sm modal-dialog-centered" role="document">
<div class="modal-content">
<div class="modal-header">
    <h5 class="modal-title" id="exampleModalLongTitle">User </h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<form enctype="multipart/form-data" action="{{url('/user_store')}}" method="post">
  @csrf
    <div class="modal-body">
        <div class="row">
            <div class="col-sm-12 form-group">
                <label>Role</label>
                <select class=" col-sm-12 form-control loan" required name="role">
                    <option  value="1">Admin</option>
                    <option   value="2">User</option>
                    @if(Session::get('role')==3)
                    <option   value="3">Super Admin</option>
                    @endif
                </select> 
            </div> 
        <div class="col-sm-12 form-group">
            <label>Name</label>
            <input class="form-control"  required type="text"  name="name">
        </div>  
 
        <div class="col-sm-12 form-group">
            <label>Mobile</label>
            <input class="form-control"  required type="number" min="1"  name="mobile">
        </div>
        <div class="col-sm-12 form-group">
            <label>Password</label>
            <input class="form-control"  required type="text"  name="password">
        </div>
        <div class="col-sm-12 form-group">
            <label>Image</label>
            <input class="form-control"  required type="file"  name="image">
        </div>
        </div>
       </div>
    <div class="modal-footer">
        <button type="reset" class="btn btn-primary" >Clear</button>
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Submit</button>
    </div>
</form>
</div>
</div>
</div>

{{-- Setting --}}
<div class="modal fade" id="exampleModalCenter_edit2" tabindex="-1" role="dialog"
aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
<div class="modal-dialog  modal-sm modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle">Setting</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
      <form enctype="multipart/form-data" action="{{url('/user/setting')}}" method="post" >
        @csrf
    <div class="modal-body">
        <div class="row">
            <div class="col-sm-12 form-group">
                <label>MemberShip</label>
                <select class=" col-sm-12 form-control member" name="member">
                <option  value="0">Hidden</option>
                <option   value="1">Show</option>
                </select> 
                <input class="cId" type="hidden" name="id" id="id">      
            </div>
             <div class="col-sm-12 form-group">
            <label>DPS</label>
            <select class=" col-sm-12 form-control dps" name="dps">
                <option  value="0">Hidden</option>
                <option   value="1">Show</option>
            </select>       
        </div>
        <div class="col-sm-12 form-group">
            <label>Withdraw</label>
            <select class=" col-sm-12 form-control loan" name="loan">
                <option  value="0">Hidden</option>
                <option   value="1">Show</option>
            </select>       
        </div>               
        </div>
       </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Update</button>
    </div>
</form>
</div>
</div>
</div>
{{-- Edit slider Modal --}}

<div class="modal fade" id="exampleModalCenter_edit" tabindex="-1" role="dialog"
aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
<div class="modal-dialog  modal-sm modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle"> Update</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
      <form enctype="multipart/form-data" action="{{url('/user_update')}}" method="post" >
        @csrf
    <div class="modal-body">
        <div class="row">

         <div class="col-sm-12 form-group">
            <label>Name</label>
            <input class="form-control name"  required type="text"  name="name">
            <input class="cId" type="hidden" name="id" id="id">

        </div>  
        <div class="col-sm-12 form-group">
            <label>Mobile</label>
            <input class="form-control mobile"   type="number"  name="mobile">
        </div> 
        <div class="col-sm-12 form-group">
            <label>Image</label>
            <input class="form-control image"   type="file"  name="image">
        </div>
        <div class="col-sm-12 form-group">
            <label>Password</label>
            <input class="form-control"   type="text"  name="password">
        </div>
        <div class="col-sm-12 form-group">
            <label>Status</label>
            <select class=" col-sm-12 form-control status" name="status">
            <option  value="1">Active</option>
            <option   value="0">Inactive</option>
            </select>
        
        </div>
        <div class="col-sm-12 form-group">
            <label>Role</label>
            <select class=" col-sm-12 form-control role" required name="role">
                <option  value="1">Admin</option>
                <option   value="2">User</option>
                @if(Session::get('role')==3)
                <option   value="3">Super Admin</option>
                @endif
            </select> 
        </div>               
        </div>
       </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Update</button>
    </div>
</form>
</div>
</div>
</div>
</div>
<div class="card shadow">
    <div class="card-header ">
    <div class="row">
        <div class="col-md-6"><h5 class="m-0 font-weight-bold ">Users</h5></div>   
        <div class="col-md-6">
                <button type="button" class="btn btn-success fa-pull-right" data-toggle="modal" data-target="#exampleModalCenter" >
                    Add User       
            </button>
        </div>
    </div> 
    </div> 
    <div class="card-body">
      <div class="table-responsive">
       <table id="example"  class="table table-bordered table-hover table-sm">
          <thead>
             <tr class="bg-info">
              <th>SL</th>
              <th>Image</th>
              <th>Name</th>
              <th>Role</th>
              <th>Mobile</th>
              <th>Joing</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
          <?php $k=1; ?>

          @foreach($user as $user)
         <tr>
          <td>{{$k++}}</td>
          <td> <img src="{{ asset($user->image) }}" alt="{{ $user->name }}" height="50" width="50" ></td>
          @if(session::get('role')==3)
          <td>  <a href="{{url('/userdash/'.$user->id)}}" target="blank">{{$user->name}}</a> </td>
          @else
          <td> {{$user->name}}</td>

          @endif

          <td>@if($user->role==1) <b>Admin</b> @elseif ($user->role==3) <span style="color:blue">Super Admin</span>  @else User @endif</td>
          <td>{{$user->mobile}}</td>
          <td>{{ date('d-M-Y', strtotime($user->created_at)) }}</td>
          <td>@if($user->status==1) <span class="right badge badge-success">Active</span> @else <span class="right badge badge-danger">Inactive</span> @endif </td>

            <td>
              
                <div class="dropdown show">
                  <a class="btn btn-secondary dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  </a>
      
                  <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                   
                     @if(session::get('role')==1)  
                          @if($user->id==Session::get('ID'))
                          <a class="dropdown-item" href="" onclick= 'edit({{$user->id}});' data-toggle="modal" id="edit" 
                            data-target="#exampleModalCenter_edit"> Edit</a>
                          @endif
                            @if($user->role==2 )     
                                <a class="dropdown-item" href="{{url('/unpaid/'.$user->id)}}">Sheet</a>
                                <a class="dropdown-item" href="{{url('/total/'.$user->id)}}">Summary</a>
                                <a class="dropdown-item" href="" onclick= 'edit({{$user->id}});' data-toggle="modal" id="edit" 
                                    data-target="#exampleModalCenter_edit2">Setting</a>                        
                                <a class="dropdown-item" href="" onclick= 'edit({{$user->id}});' data-toggle="modal" id="edit" 
                                    data-target="#exampleModalCenter_edit"> Edit</a> 
                             @endif
                     @else
                            <a class="dropdown-item" href="" onclick= 'edit({{$user->id}});' data-toggle="modal" id="edit" 
                            data-target="#exampleModalCenter_edit"> Edit</a>              
                            <a class="dropdown-item" onclick="return confirm('Confirm Delete This Data')" href="{{url('/user_delete/'.$user->id)}} ">Delete</a>
                     
                            @if($user->role==2 )
                                <a class="dropdown-item" href="" onclick= 'edit({{$user->id}});' data-toggle="modal" id="edit" 
                                    data-target="#exampleModalCenter_edit2">Setting</a>
                                
                                <a class="dropdown-item" href="{{url('/unpaid/'.$user->id)}}">Sheet</a>
                                <a class="dropdown-item" href="{{url('/total/'.$user->id)}}">Summary</a>
                            @endif
                    @endif
                  </div>
                  </div>
             
                  </td>
           </tr>
         @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>  
<script>
  function edit(id) {
          var x =id;
          
          $.ajax({
              type:'GET',
              url:"{{url('/user_edit')}}/"+x,
              success:function(response){
                  console.log(response);
                  $('.name').val(response.name);
                  $('.mobile').val(response.mobile);
                  $('.status').val(response.status);
                  $('.loan').val(response.loan);
                  $('.dps').val(response.dps);
                  $('.member').val(response.member);
                  $('.role').val(response.role);
                  $('.cId').val(response.id);           
                 },
              error:function(xhr,status,error){
                  console.log(error);
                  
              }
  
          });
      }
  
          
  </script>

@endsection