@extends('admin.master')
@section('title')
@php $world=DB::table('companies')->first(); @endphp
Daily Expense || {{$world->name}}
@endsection
@section('content')
<div class="page-content fade-in-up">
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
<div class="modal-dialog modal-sm modal-dialog-centered" role="document">
<div class="modal-content">
<div class="modal-header">
    <h5 class="modal-title" id="exampleModalLongTitle">Expense</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<form enctype="multipart/form-data" action="{{url('/expense_store')}}" method="post">
  @csrf
    <div class="modal-body">
        <div class="row">
          
        <div class="col-sm-12 form-group">
            <label>Expense Date</label>
            <input class="form-control"  required value="<?php echo date('Y-m-d'); ?>" type="date"  name="date">
        </div> 
        <div class="col-sm-12 form-group">
          <label>Expense Type</label>
          <input class="form-control"  required type="text"  name="type">
      </div> 
        <div class="col-sm-12 form-group">
          <label>Expense Purpose</label>
          <select name="purpose"  required class="form-control">
            <option value="">Select  Purpose</option>
            <option value="Bank-Transfer">Bank Transfer</option>
            <option value="Rent">Rent</option>  
            <option value="Salary">Salary</option>     
            <option value="Property-Taxes">Property Taxes</option>     
            <option value="Utility-Bills">Utility Bills</option>     
            <option value="Vehicle">Vehicle</option>     
            <option value="Health">Health</option>     
            <option value="Gifts">Gifts</option>     
            <option value="Eating">Eating</option>     
            <option value="Doctor">Doctor</option>     
            <option value="Mobile-Bill">Mobile Bill</option>     
            <option value="Newspaper">Newspaper </option>     
            <option value="Entertainment">Entertainment</option>     
            <option value="Groceries">Groceries</option>     
            <option value="Clothing ">Clothing </option>     
            <option value="Others">Others</option>     
           </select>
      </div>

        <div class="col-sm-12 form-group">
            <label>Amount</label>
            <input class="form-control"  required type="number"  name="amount">
        </div> 
        </div>
       </div>
    <div class="modal-footer">
        <button type="reset" class="btn btn-primary" >Clear</button>
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Submit</button>
    </div>
</form>
</div>
</div>
</div>

{{-- Edit slider Modal --}}

<div class="modal fade" id="exampleModalCenter_edit" tabindex="-1" role="dialog"
aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
<div class="modal-dialog modal-sm modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle"> Update</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
      <form enctype="multipart/form-data" action="{{url('/expense_update')}}" method="post" >
        @csrf
    <div class="modal-body">
        <div class="row">
          <div class="col-sm-12 form-group">
            <label>Expense Date</label>
            <input class="form-control date"  required value="<?php echo date('Y-m-d'); ?>" type="date"  name="date">
        </div> 
          <div class="col-sm-12 form-group">
            <label>Expense Type</label>
            <input class="form-control type"  required type="text"  name="type">
            <input class="cId" type="hidden" name="id" id="id">
        </div> 
        <div class="col-sm-12 form-group">
          <label>Expense Purpose</label>
          <select name="purpose"  required class="form-control purpose">
            <option value="">Select  Purpose</option>
            <option value="Bank-Transfer">Bank Transfer</option>
            <option value="Rent">Rent</option>     
            <option value="Salary">Salary</option>     
            <option value="Property-Taxes">Property Taxes</option>     
            <option value="Utility-Bills">Utility Bills</option>     
            <option value="Vehicle">Vehicle</option>     
            <option value="Health">Health</option>     
            <option value="Gifts">Gifts</option>     
            <option value="Eating">Eating</option>     
            <option value="Doctor">Doctor</option>     
            <option value="Mobile-Bill">Mobile Bill</option>     
            <option value="Newspaper">Newspaper </option>     
            <option value="Entertainment">Entertainment</option>     
            <option value="Groceries">Groceries</option>     
            <option value="Clothing ">Clothing </option>     
            <option value="Others">Others</option>     
           </select>
      </div>
        <div class="col-sm-12 form-group">
            <label>Amount</label>
            <input class="form-control amount"  required type="number"  name="amount">
        </div>          
        </div>
       </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Update</button>
    </div>
</form>
</div>
</div>
</div>
</div>
<div class="card shadow">
    <div class="card-header ">
    <div class="row">
        <div class="col-md-6"><h5 class="m-0 font-weight-bold ">All Expense</h5></div>   
        <div class="col-md-6">
                <button type="button" class="btn btn-success fa-pull-right" data-toggle="modal" data-target="#exampleModalCenter" >
             Business Expense      
            </button>
        </div>
    </div> 
    </div> 
    <div class="card-body">
      <div class="table-responsive">
       <table id="example" class="table table-bordered table-hover table-sm">
          <thead>
            <tr>
              <th>SL</th>
              <th>Type</th>
              <th>Purpose</th>
              <th>Amount</th>
              <th>Date</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
          <?php $sl=1; ?>
          @foreach($expense as $expense)
         <tr>
          <td>{{$sl++}}</td>
          <td>{{$expense->type}}</td>
          <td>{{$expense->purpose}}</td>
          <td>{{$expense->amount}}</td>
          <td>{{ date('d-M-Y', strtotime($expense->date)) }}</td>
          <td><a href="" onclick= 'edit({{$expense->id}});' data-toggle="modal" id="edit" 
            data-target="#exampleModalCenter_edit" class="btn btn-sm btn-info" ><i class="fa fa-edit "></i></a>
             @if(Session::get("role")==3)
            <a href="{{url('/expense_delete/'.$expense->id)}}" class="btn btn-sm btn-danger" onclick='alert("Confirm Delete ??")' ><i class="fa fa-trash "></i></a>
            @endif
            </td>
           </tr>
         </tr>
         @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>  
<script>
  function edit(id) {
          var x =id;
          
          $.ajax({
              type:'GET',
              url:"{{url('/expense_edit')}}/"+x,
              success:function(response){
                  console.log(response);
                  $('.type').val(response.type);
                  $('.purpose').val(response.purpose);
                  $('.amount').val(response.amount);
                  $('.date').val(response.date);

                  $('.cId').val(response.id);
           
              },
              error:function(xhr,status,error){
                  console.log(error);
                  
              }
  
          });
      }
  
          
  </script>

@endsection