@extends('admin.master')
@section('title')
@php $world=DB::table('companies')->first(); @endphp
{{$details->name}} || {{$world->name}}
@endsection
@section('content')
<div class="card shadow">
  <div class="card-body">
            <div class="card">        
            <a href="{{url('/loan')}}" class="btn btn-danger " title="View"> 
                         Loan List
                    </a>
                </div>
            <div class="card-body">
                    <div class="row">
                     <div  class="col-md-12">
                      <h3><b>Summary</b></h3>
                        <div class="table-responsive">
                      <table class="table table-bordered">
                    <thead>
                         <tr class="bg-secondary">
                        <th scope="col">Loan Amount</th>
                        <th scope="col">Interest</th>
                        <th scope="col">Total Interest</th>
                        <th scope="col">Total Amount</th>
                        <th scope="col">Process Fee</th>
                        <th scope="col">Loan Created</th>                     
                        </tr>
                         <tr class="bg-secondary">
                        <td>{{$loan->amount}}</td>
                        <td>{{$loan->interest}} % </td>
                        <td>{{$loan->totalinterest}} </td>
                        <td>{{$loan->totalloan}}</td>
                        <td>{{($loan->process)}}</td>
                        <td>{{($user->name)}}</td>
                       
                        </tr>
                    </thead>
                    </table>
                    </div>
                      </div> 
                      <div  class="col-md-6">
                      <br>
                      <h4><b>Member Information</b></h4>
                        <div class="table-responsive">
                        <table class="table table-bordered">
                    <thead>
                        <tr>
                        <td scope="col">Name</td>
                        <td scope="col"> <a href="{{url('/profile/'.$details->id)}}" target="blank">{{$details->name}}</a></td>
                        </tr>
                        <tr>
                        <tr>
                        <td scope="col">Member ID</td>
                        <td scope="col">{{$details->memberno}}</td>
                        </tr>
                        <tr>
                        <td scope="col">Mobile</td>
                        <td scope="col">{{$details->mobile}}</td>
                        </tr>
                        <tr>
                        <td scope="col">NID</td>
                        <td scope="col">{{$details->nid}}</td>
                        </tr>
                        <tr>
                        <td scope="col">Father / Husband</td>
                        <td scope="col">{{$details->fhname}}</td>
                        </tr>
                        <tr>
                        <td scope="col">Address</td>
                        <td scope="col">{{$details->preaddress}}</td>
                        </tr>
                        <tr>
                        <td scope="col">Stamp</td>
                        <td scope="col">{{$loan->stamp}} Tk</td>
                         </tr>
                        <tr>
                          <td scope="col">Bank Details</td>
                          <td scope="col">{{$loan->bankdetails}}</td>
                        </tr>
                    </thead>
                    </table>
                      </div>
                      </div> 
                     
                         <div  class="col-md-6">
                         <br>
                      <h4><b>Loan Information</b></h4>
                        <div class="table-responsive">
                      <table class="table table-bordered">
                    <thead>
                        <tr>
                        <td scope="col">Created Date</td>
                        <td scope="col">{{ date('d-M-Y', strtotime($loan->created_at)) }}</td>
                        </tr>
                        <tr>
                        <td scope="col">Loan Date</td>
                      <td scope="col">{{ date('d-M-Y', strtotime($loan->date)) }}</td>

                        </tr>
                        <tr>
                        <td scope="col">Loan Amount</td>
                        <td scope="col">{{$loan->amount}}</td>
                        </tr>
                         <tr>
                        <td scope="col">Process Fee </td>
                        <td scope="col">{{$loan->process}}</td>
                        </tr>
                          <tr>
                        <td scope="col">Interest </td>
                        <td scope="col">{{$loan->totalinterest}}</td>
                        </tr>
                         <tr>
                        <td scope="col">Pay Total </td>
                        <td scope="col"><b>{{$loan->totalloan}}</b></td>
                        </tr>
                    </thead>
                    </table>
                      </div>
                      </div>
                      <div class="col-md-12">
                        <hr><hr>
                      </div>
                      <div  class="col-md-6">
                      <h4><b>Guarantor Information</b></h4>
                      <div class="table-responsive">
                    <table class="table table-bordered">
                  <thead>
                     
                      <tr>
                      <td colspan="2" class="text-center"><b>Admin Guarantor</b></td>
                      </tr>
                      @php $admin=DB::table('users')->find($loan->zadmin) @endphp
                       <tr>
                      <td scope="col">Name</td>
                      <td scope="col">{{@$admin->name}}</td>
                      </tr>
                      <tr>
                      <td scope="col">Mobile</td>
                      <td scope="col">{{@$admin->mobile}}</td>
                      </tr>
                       <tr>
                      <td colspan="2" class="text-center"><b>Member Guarantor</b></td>
                      </tr>
                      @php $member=DB::table('members')->find($loan->zmember) @endphp
                      <tr>
                      <td scope="col">Name</td>
                      <td > <a href="{{url('/profile/'.$loan->zmember)}}" target="blank"> {{@$member->name}}</a></td>
                      </tr>
                      <tr>
                        <td scope="col">Member ID</td>
                        <td scope="col">{{@$member->memberno}}</td>
                        </tr>
                      <tr>
                      <td scope="col">Mobile</td>
                      <td scope="col">{{@$member->mobile}}</td>
                      </tr>
                      <tr>
                        <td scope="col">Address</td>
                        <td scope="col">{{@$member->preaddress}}</td>
                        </tr>
                  </thead>
                  </table>
                    </div>
                  </div>
                    <div  class="col-md-6">
                    <h4><b>Others Guarantor Information</b></h4>
                    <div class="table-responsive">
                  <table class="table table-bordered">
                <thead>
                    <tr>
                    <td scope="col">Name</td>
                    <td scope="col">{{$loan->zname}}</td>
                    </tr>
                     <tr>
                    <td scope="col">Mobile</td>
                    <td scope="col">{{$loan->zmobile}}</td>
                    </tr>
                      <tr>
                    <td scope="col">NID </td>
                    <td scope="col">{{$loan->znid}}</td>
                    </tr>
                     <tr>
                    <td colspan="2">   <img src="{{ asset($loan->bank) }}"  height="350" width="100%" ></td>
                 
                    </tr>
                </thead>
                </table>
                  </div>
                  </div>
                </div>

                                     
                    </div>
             </div>                     
</div>

</div>

@endsection
