@extends('admin.master')
@section('title')
@php $world=DB::table('companies')->first(); @endphp
Loan || {{$world->name}}
@endsection
@section('content')
<div class="page-content fade-in-up">
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
<div class="modal-dialog  modal-lg  modal-dialog-centered" role="document">
<div class="modal-content">
<div class="modal-header">
    <h5 class="modal-title" id="exampleModalLongTitle">Make a Loan </h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<form enctype="multipart/form-data" action="{{url('/loan/store')}}" method="post">
  @csrf
    <div class="modal-body">
        <div class="row">
            <div class="col-sm-6 form-group">
                <label>Member</label>
                {{-- <select class="form-control" required  name="member"> --}}
            <select name="member" required class="form-control select2bs4" style="width: 100%;">
                <option value="">Select Member</option>
                @foreach($member as $mem)
                <option value="{{$mem->id}}">{{$mem->memberno}}={{$mem->name}}</option>
                @endforeach
                </select>
            </div>
       <div class="col-sm-4 form-group">
            <label>Date</label>
            <input class="form-control"   required type="date" value="<?php echo date('Y-m-d'); ?>"   name="date">
        </div>
      
        <div class="col-sm-2 form-group">
            <label>Loan No.</label>
            <input class="form-control" placeholder="346"   required type="number" min="1"   name="loanno">
        </div>
        
        <div class="col-sm-3 form-group">
            <label>Loan Amount</label>
            <input class="form-control"  placeholder="50000"  required type="number" min="1"  name="amount">
        </div>
        <div class="col-sm-3 form-group">
            <label>Interest</label>
            <input class="form-control" placeholder="%"  required type="number" min="1"   name="interest">
        </div>
        <div class="col-sm-3 form-group">
            <label>Process Fee</label>
            <input class="form-control" placeholder="100"  min="1"  type="number"  name="process">
        </div>
        <div class="col-sm-3 form-group">
            <label>Paid Days</label>
            <input class="form-control" placeholder="120" min="1"  required type="number"  name="day">
        </div> 
        <div class="col-sm-3 form-group">
            <label>Installment Type</label>
            <select name="type"  class="form-control select2bs4" required style="width: 100%;">
                <option value="">Select  Type</option>          
                <option value="Daily">Daily</option>
                <option value="Weekly">Weekly</option>
                <option value="Monthly">Monthly</option>
                <option value="Yearly">Yearly</option>
                <option value="None">None</option>
               </select>
        </div>
        <div class="col-sm-3 form-group">
            <label>Stamp</label>
            <select name="stamp"  class="form-control select2bs4" required style="width: 100%;">
                <option value="">Stamp Type</option>          
                <option value="100">100</option>
                <option value="200">200</option>
                <option value="300">300</option>
                <option value="500">500</option>
                <option value="1000">1000</option>
                <option value="2000">2000</option>
                <option value="None">None</option>
               </select>
        </div>
        <div class="col-sm-6 form-group">
            <label>Bank Details</label>
            <input class="form-control" placeholder="Bank:Jumuna ACC:8756XXXXXXXX"   type="text"  name="bankdetails">
        </div>

        <div class="col-sm-12 form-group">
            <hr>
        </div> 
        <div class="col-sm-6 form-group">
            <label>Guarantor Admin</label>
            <select name="zadmin"  class="form-control select2bs4"  style="width: 100%;">
                <option value="">Select  Admin</option>
                @foreach($user as $user)
                <option value="{{$user->id}}">{{$user->mobile}}={{$user->name}}</option>
                @endforeach
               </select>
        </div>
        <div class="col-sm-6 form-group">
            <label>Guarantor Member</label>
            <select name="zmember"  class="form-control select2bs4" style="width: 100%;">
                <option value="">Select  Member</option>
                @foreach($zmember as $zmember)
                <option value="{{$zmember->id}}">{{$zmember->memberno}}={{$zmember->name}}</option>
                @endforeach
               </select>
        </div>
        <div class="col-sm-4 form-group">
            <label>Others Guarantor</label>
            <input class="form-control " placeholder="Zamindar Name" min="0"   type="text"  name="zname">
        </div> 
        <div class="col-sm-4 form-group">
            <label>Mobile</label>
            <input class="form-control "  placeholder="Mobile " min="0"  type="number"  name="zmobile">
        </div> 
        <div class="col-sm-4 form-group">
            <label>NID</label>
            <input class="form-control "  placeholder="NID " min="0"  type="number"  name="znid">
        </div> 
        <div class="col-sm-4 form-group">
            <label>Bank Check / Photo</label>
            <input class="form-control "  type="file"  name="bank">
        </div>
        <div class="col-sm-4 form-group">
         
        </div>
        <div class="form-check col-sm-4">
            <br>
            
			<label class="form-check-label" for="defaultCheck1">
				Send SMS To Member ?
			  </label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<input class="form-check-input" type="checkbox" name="SMS" value="1" id="defaultCheck1">
			
		  </div>
        </div>
       </div>
    <div class="modal-footer">
        <button type="reset" class="btn btn-primary" >Clear</button>
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Submit</button>
    </div>
</form>
</div>
</div>
</div>

{{-- Edit slider Modal --}}

<div class="modal fade" id="exampleModalCenter_edit" tabindex="-1" role="dialog"
aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle"> Update</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
      <form enctype="multipart/form-data" action="{{url('/loan/update')}}" method="post" >
        @csrf
    <div class="modal-body">
        <div class="row">
            <div class="col-sm-6 form-group">
                <label>Member</label>
                {{-- <select class="form-control" required  name="member"> --}}
            <select name="member" required class="form-control select2bs4 member" member style="width: 100%;">
                <option value="">Select Member</option>
                @foreach($members as $mem)
                <option value="{{$mem->id}}">{{$mem->memberno}}={{$mem->name}}</option>
                @endforeach
                </select>
                <input class="cId" type="hidden" name="id" id="id">

            </div>
       <div class="col-sm-4 form-group">
            <label>Date</label>
            <input class="form-control date"   required type="date" value="<?php echo date('Y-m-d'); ?>"   name="date">
        </div>
      
        <div class="col-sm-2 form-group">
            <label>Loan No.</label>
            <input class="form-control loanno" placeholder="346"   required type="number" min="1"   name="loanno">
        </div>
        
        <div class="col-sm-3 form-group">
            <label>Loan Amount</label>
            <input class="form-control amount"  placeholder="50000"  required type="number" min="1"  name="amount">
        </div>
        <div class="col-sm-3 form-group">
            <label>Interest</label>
            <input class="form-control interest" placeholder="%"  required type="number" min="1"   name="interest">
        </div>
        <div class="col-sm-3 form-group">
            <label>Process Fee</label>
            <input class="form-control process" placeholder="100"  min="1"  type="number"  name="process">
        </div>
        <div class="col-sm-3 form-group">
            <label>Paid Days</label>
            <input class="form-control day" placeholder="120" min="1"  required type="number"  name="day">
        </div> 
        <div class="col-sm-3 form-group">
            <label>Installment Type</label>
            <select name="type"  class="form-control select2bs4 type" required style="width: 100%;">
                <option value="">Select  Type</option>          
                <option value="Daily">Daily</option>
                <option value="Weekly">Weekly</option>
                <option value="Monthly">Monthly</option>
                <option value="Yearly">Yearly</option>
                <option value="None">None</option>
               </select>
        </div>
        <div class="col-sm-3 form-group">
            <label>Stamp</label>
            <select name="stamp"  class="form-control select2bs4 stamp" required style="width: 100%;">
                <option value="">Stamp Type</option>          
                <option value="100">100</option>
                <option value="200">200</option>
                <option value="300">300</option>
                <option value="500">500</option>
                <option value="1000">1000</option>
                <option value="2000">2000</option>
                <option value="None">None</option>
               </select>
        </div>
        <div class="col-sm-6 form-group">
            <label>Bank Details</label>
            <input class="form-control bankdetails" placeholder="Bank:Jumuna ACC:8756XXXXXXXX"   type="text"  name="bankdetails">
        </div>
        <div class="col-sm-12 form-group">
            <hr>
        </div> 
        <div class="col-sm-6 form-group">
            <label>Guarantor Admin</label>
            <select name="zadmin"  class="form-control select2bs4 zadmin"  style="width: 100%;">
                <option value="">Select  Admin</option>
                @foreach($users as $user)
                <option value="{{$user->id}}">{{$user->mobile}}={{$user->name}}</option>
                @endforeach
               </select>
        </div>
        <div class="col-sm-6 form-group">
            <label>Guarantor Member</label>
            <select name="zmember"  class="form-control select2bs4 zmember" style="width: 100%;">
                <option value="">Select  Member</option>
                @foreach($zmembers as $zmember)
                <option value="{{$zmember->id}}">{{$zmember->memberno}}={{$zmember->name}}</option>
                @endforeach
               </select>
        </div>
        <div class="col-sm-4 form-group">
            <label>Others Guarantor</label>
            <input class="form-control zname" placeholder="Zamindar Name" min="0"   type="text"  name="zname">
        </div> 
        <div class="col-sm-4 form-group">
            <label>Mobile</label>
            <input class="form-control zmobile"  placeholder="Mobile " min="0"  type="number"  name="zmobile">
        </div> 
        <div class="col-sm-4 form-group">
            <label>NID</label>
            <input class="form-control znid"  placeholder="NID " min="0"  type="number"  name="znid">
        </div> 
        <div class="col-sm-4 form-group">
            <label>Bank Check / Photo</label>
            <input class="form-control"  type="file"  name="bank">
        </div>
        <div class="col-sm-4 form-group">
         
        </div>
        <div class="form-check col-sm-4">
            <br>
            
			<label class="form-check-label" for="defaultCheck1">
				Send SMS To Member ?
			  </label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
			
		  </div>
        </div>
       </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-success">Update</button>
    </div>
</form>
</div>
</div>
</div>
</div>
<div class="card shadow">
    <div class="card-header ">
    <div class="row">
        <div class="col-md-3">
          <h3 class="m-0 font-weight-bold ">Loan List</h3>
        </div>   
  
    <div class="col-md-6">
      <form action="{{url('/loan')}}" method="get"> 
              @csrf 
           <div class="row">    
                      <div class="col-md-8">
                        <select name="member" required class="form-control select2bs4" style="width: 100%;">
                          <option value="">Select  Member</option>
                          @foreach($member as $member)
                          <option value="{{$member->id}}">{{$member->memberno}}={{$member->name}}</option>
                          @endforeach
                         </select>
                       </div>
                        <div class="col-md-4 ">
                         <input type="submit" class="btn btn-secondary" value="Search"/>
                              </div>
                        </div>
                          </form>
                    
                  </div>
                  <div class="col-md-3">
                <button type="button" class="btn btn-success fa-pull-right" data-toggle="modal" data-target="#exampleModalCenter" >
             New Loan    
            </button>
        </div>
            
          </div> 
        </div> 
    <div class="card-body">
      <div class="table-responsive">
       <table class="table table-bordered table-hover table-sm">
          <thead>
            <tr class="bg-info">
              <th>Sl</th>
              <th>Member</th>
              <th>Loan No.</th>
              <th>Type</th>
              <th>Loan Amount</th>
              <th>Interest</th>
              <th>Program</th>
              <th>Date</th>
              <th>Status</th>
              <th class="text-center">Action</th>
            </tr>
          </thead>
          <tbody>
       
          @foreach($loan as $loans)

          @php $check=DB::table('loans')->where('loanno',$loans->loanno)->first();          
              $start =strtotime($check->date);
              $end =strtotime(date("Y-m-d"));
              $days_between = ceil(abs($end - $start) / 86400); 
             
          @endphp
         <tr>
          <td>{{$loans->id}}</td>       
          <td> <a href="{{url('/profile/'.$loans->member)}}" target="blank">{{$loans->name}}  <span class="right badge badge-danger">{{$loans->memberno}}</span></a></td>
          <td>{{$loans->loanno}}</td>
          <td>{{$loans->type}}</td>
          <td>{{$loans->amount}}</td>
          <td>{{$loans->interest}}%</td>
          <td>{{$loans->day}} Days</td>
          <td>{{ date('d-M-Y', strtotime($loans->date)) }}</td>
          <td>
              @if($loans->day<$days_between)
                <span class="right badge badge-warning">Timeout</span>
              @else
              <span class="right badge badge-primary">Process</span>
              @endif    
        </td>
              <td class="text-center">       
            <div class="dropdown show">
                <a  href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-h"></i></a>

                <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <a class="dropdown-item" href="" onclick= 'edit({{$loans->id}});' data-toggle="modal" id="edit" 
                        data-target="#exampleModalCenter_edit"> Edit</a>
                <a class="dropdown-item" href="{{url('/loan/view/'.$loans->id)}}">View</a>
                @if(Session::get('role')==3)
                   <a  class="dropdown-item"  href="{{url('/loan/delete/'.$loans->id)}}" onclick='return confirm("Confirm Delete ??")' >Delete</a>
                @endif

                </div>
                </div>
            
            </td>
           </tr>
         </tr>
         @endforeach
          </tbody>
        </table>
         {{ $loan->links() }}
      </div>
    </div>
  </div>  
<script>
  function edit(id) {
          var x =id;
          
          $.ajax({
              type:'GET',
              url:"{{url('/loan/edit')}}/"+x,
              success:function(response){
                  console.log(response);
                  $('.date').val(response.date);
                  $('.loanno').val(response.loanno);
                  $('.member').val(response.member);
                  $('.amount').val(response.amount);
                  $('.process').val(response.process);
                  $('.interest').val(response.interest);
                  $('.day').val(response.day);
                  $('.type').val(response.type);
                  $('.zadmin').val(response.zadmin);
                  $('.zmember').val(response.zmember);
                  $('.zname').val(response.zname);
                  $('.zmobile').val(response.zmobile);
                  $('.znid').val(response.znid);
                  $('.bankdetails').val(response.bankdetails);
                  $('.stamp').val(response.stamp);
                  $('.cId').val(response.id);
           
              },
              error:function(xhr,status,error){
                  console.log(error);
                  
              }
  
          });
      }
   
          
  </script>

@endsection